//	CDialogAbout.c

#include "ADFS_Prefs.h"
#include "ADFS_Menus.h"
#include "FSUtils.h"
#include "IC_Errors.h"
#include "Utils.h"

#include "CDialogAbout.h"

/********************************************************/
enum {
	kAboutStr_VERS, 
	kAboutStr_EMAIL, 
	kAboutStr_DATE, 
	kAboutStr_ROGUE, 
	kAboutStr_NUMTYPES
};

typedef 	char		AboutStr[32];
#define		kAboutStringsCenter	11
AboutStr	gAboutStrings[kAboutStr_NUMTYPES] = {
	"",								// Carbon Version x.xAx
	"me@davecotter.com",
	"[error getting build date]", 	//	 August 13, 2003 ",
	""
};

char	CreditStr[] = "Shell program DropShell by Leonard Rosenthol, "	\
	"Marshall Clow and Stephan Somogyi.  Integer Basic detokenizer by Bill North.";
	
enum {
	kAbout_THUMBNAIL = 1, 
	kAbout_BY_LAZ, 
	kAbout_ABOUT_STRINGS, 
	kAbout_DROPSHELL_CREDIT, 
	
	kAbout_NUMTYPES
};

/********************************************************/
CDialogAbout		*gCDialogAbout = NULL;

void		ShowAbout(void)
{
	if (check_key_down(option_key)) {
		AlertID("You Betcha!  But you don't "
			"get a number (it's not about you, personally).", -1);
	} else {
		if (!gCDialogAbout) {
			gCDialogAbout = new CDialogAbout;
			
			if (gCDialogAbout) {
				if (!gCDialogAbout->IDialogAbout()) {
					gCDialogAbout->Dispose();
					gCDialogAbout = NULL;
				}
			}
		}
	}
}

WindowRef	GetAboutWindow(void)
{
	WindowRef		dialogWindow = NULL;
	
	if (gCDialogAbout) {
		DialogRef	aboutDlgRef = gCDialogAbout->GetDialogRef();
		
		dialogWindow = GetDialogWindow(aboutDlgRef);
	}
	
	return dialogWindow;
}

void	CDialogAbout::DoKeyDown(EventRecord *event)
{
	char		ch			= VirtualASCII(event);
	Boolean		disposeB	=
		ch == ENTER_KEY
		|| ch == RETURN_KEY
		|| ch == ESC_CLEAR_KEY
		|| (
			BitAnd(event->modifiers, cmdKey)
			&& (ch == '.' || ch == 'W')
		);

	if (disposeB) {
		Dispose();
	} else {
		_inherited::DoKeyDown(event);
	}
}

void	CDialogAbout::DoClick(EventRecord *event)
{
	if (FrontWindow() != GetAboutWindow()) {
		_inherited::DoClick(event);
	} else {
		Dispose();
	}
}

/********************************************************/

Boolean		CDialogAbout::IDialogAbout(void)
{
	Boolean		success = TRUE;
	
	//	get it hidden, then show
	success = _inherited::IDialog(ADFS_Window_MODELESS_DIALOG, 129);
	
	if (success) {
		Rect	aboutR = (**gPrefsH).windA[PREF_Wind_ABOUT];
		
		SetDlgItemUseStdDraw(kAbout_ABOUT_STRINGS);
		SetDlgItemUseStdDraw(kAbout_DROPSHELL_CREDIT);

		if (!EmptyRect(&aboutR)) {
			MoveWindow(
				GetAboutWindow(),
				aboutR.left, aboutR.top, FALSE);
		}

		ShowWindow(GetAboutWindow());
	}

	return success;
}

void		CDialogAbout::Dispose(void)
{
	gCDialogAbout = NULL;

	_inherited::Dispose();
}

/*************************************************/
void	CDialogAbout::DialogItemStandardDrawProc(
	DialogItemIndex	itemNo, 
	Rect			*itemRectP)
{
	switch (itemNo) {

		case kAbout_ABOUT_STRINGS: {
			short			loop, spacesS;
			VersRecHndl		versH = (VersRecHndl)GetResource('vers', 1);
			VersRec			versRec = **versH;
			char			versionAC[256], *curZ;
			char			dateAC[256];
			
			TextSize(9);
			TextMode(srcOr);

			ReleaseResource((Handle)versH);
			
			TextFont(GetAppFonts(40));

			for (loop = 0; loop < kAboutStr_NUMTYPES; loop++) {
				
				switch (loop) {

					default: {
						curZ = gAboutStrings[loop];
						break;
					}

					case kAboutStr_VERS: {
						#ifndef __68k__
							sprintf(versionAC, "Carbon Version %#s", versRec.shortVersion);
						#else
							sprintf(versionAC, "68k Version %#s", versRec.shortVersion);
						#endif
						curZ = versionAC;
						break;
					}

					case kAboutStr_DATE: {
						OSErr			err = noErr;
						FSSpec			appSpecP;
						DateTimeRec		creDate; 
						
						err = FSpThisApp(&appSpecP);
						
						if (!err) {
							DateTimeRec		modDate;

							err = FSpGetFileDates(&appSpecP, &creDate, &modDate);
						};
						
						if (!err) {
							char		*GetTimeString(
								DateTimeRec		*dtP,
								char			*buf, 
								DateForm		form = abbrevDate);
							
							creDate.hour		= 0;
							creDate.minute		= 0;
							creDate.second		= 0;
							creDate.dayOfWeek	= 0;
							GetTimeString(&creDate, dateAC);
							curZ = dateAC;
						}
						
						if (err) {
							curZ = gAboutStrings[loop];
						}
						break;
					}
				}
				
				MoveTo(itemRectP->left, (short)(itemRectP->top + 8 + loop * 9));
				spacesS = kAboutStringsCenter - ((strlen(curZ) + 1) >> 1);
				
				for (; spacesS; spacesS--) {
					DrawString("\p ");
				}

				DrawCString(curZ);
			}

			TextMode(srcCopy);
			break;
		}
		
		case kAbout_DROPSHELL_CREDIT: {
			TextSize(10);
			TextFont(FMGetFontFamilyFromName("\pGeneva"));
			DrawCStringInRect(CreditStr, itemRectP, teJustCenter);
			break;
		}
	}
}

void	CDialogAbout::UpdateMenus(void)
{
	EnableCommand(cmdQuit);
	EnableCommand(cmdAboutADFS);
	EnableCommand(cmdPreferences);
}

void	CDialogAbout::Move(EventRecord *event)
{
	_inherited::Move(event);
	(**gPrefsH).windA[PREF_Wind_ABOUT] = GetWindowRect(WindowRect_ALL_GLOBAL);
	SavePrefs();
}

